IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_RC_PGTO_PDV_PENDENTE]'))
	DROP VIEW [dbo].[V_RC_PGTO_PDV_PENDENTE]
GO
GO
CREATE VIEW [dbo].[V_RC_PGTO_PDV_PENDENTE]
AS 
SELECT    
	RC_PGTO_PDV.CD_EMP, 
	dbo.RC_PGTO_PDV.CD_CTR_PGTO, 
	dbo.RC_PGTO_PDV.DT_PGTO, 
	dbo.RC_PGTO_PDV.CD_FILIAL, 
	dbo.RC_CRED.VL_PGTO AS VLR_PAGO, 
    dbo.RC_DEB.NR_FATURA AS NR_DOC, 
	dbo.RC_CRED.CD_RC_DEB AS NR_CONTROLE, RC_CLI_CREDIARIO.CD_CLI,RC_MDL_VENDA.DS_MDL_VD ,0 AS TP_CREDITO
FROM         
	dbo.RC_PGTO_PDV 
	INNER JOIN dbo.RC_PGTO_PDV_RC_CRED ON 
	dbo.RC_PGTO_PDV.CD_CTR_PGTO = dbo.RC_PGTO_PDV_RC_CRED.CD_CTR_PGTO 
	LEFT   JOIN dbo.RC_PGTO_PDV_PENDENTE ON 
	dbo.RC_PGTO_PDV.CD_CTR_PGTO = dbo.RC_PGTO_PDV_PENDENTE.CD_CTR_PGTO 
	INNER JOIN dbo.RC_CRED ON 
	dbo.RC_PGTO_PDV_RC_CRED.CD_EMP = dbo.RC_CRED.CD_EMP AND 
	dbo.RC_PGTO_PDV_RC_CRED.CD_FILIAL = dbo.RC_CRED.CD_FILIAL AND 
	dbo.RC_PGTO_PDV_RC_CRED.CD_RC_DEB = dbo.RC_CRED.CD_RC_DEB AND 
	dbo.RC_PGTO_PDV_RC_CRED.CD_DP_LANC = dbo.RC_CRED.CD_DP_LANC 
	INNER JOIN dbo.RC_DEB ON 
	dbo.RC_CRED.CD_EMP = dbo.RC_DEB.CD_EMP AND 
	dbo.RC_CRED.CD_FILIAL = dbo.RC_DEB.CD_FILIAL AND 
	dbo.RC_CRED.CD_RC_DEB = dbo.RC_DEB.CD_RC_DEB 
	INNER JOIN RC_CLI_CREDIARIO ON 
	RC_CLI_CREDIARIO.CD_EMP=RC_DEB.CD_EMP AND
	RC_CLI_CREDIARIO.CD_CLI=RC_DEB.CD_CLI 
	INNER JOIN  RC_MDL_VENDA ON 
	RC_MDL_VENDA.CD_EMP=RC_CLI_CREDIARIO.CD_EMP AND
	RC_MDL_VENDA.CD_MDL_VD=RC_CLI_CREDIARIO.CD_MDL_VD
WHERE
	RC_PGTO_PDV_PENDENTE.CD_EMP=1

UNION ALL
SELECT     
	RC_PGTO_PDV.CD_EMP,
	dbo.RC_PGTO_PDV.CD_CTR_PGTO, 
	dbo.RC_PGTO_PDV.DT_PGTO, 
	dbo.RC_PGTO_PDV.CD_FILIAL, 
	dbo.RC_CREDIARIO_PARC_CRED.VLR_CRED AS VLR_PAGO, 
	CONVERT(VARCHAR(25), dbo.RC_CREDIARIO_PARC_CRED.CD_CTR) AS NR_DOC, 
	dbo.RC_CREDIARIO_PARC_CRED.CD_CTR AS NR_CONTORLE, 
	RC_CLI_CREDIARIO.CD_CLI,
	RC_MDL_VENDA.DS_MDL_VD, 
	1 AS TP_CREDITO
FROM         
	dbo.RC_PGTO_PDV 
	INNER   JOIN  dbo.RC_PGTO_PDV_PENDENTE ON 
	dbo.RC_PGTO_PDV.CD_CTR_PGTO = dbo.RC_PGTO_PDV_PENDENTE.CD_CTR_PGTO 

	INNER JOIN dbo.RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED ON 
	dbo.RC_PGTO_PDV.CD_CTR_PGTO = dbo.RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR_PGTO 
	
	INNER JOIN dbo.RC_CREDIARIO_PARC_CRED ON 
	dbo.RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR = dbo.RC_CREDIARIO_PARC_CRED.CD_CTR AND 
	dbo.RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR_CRED = dbo.RC_CREDIARIO_PARC_CRED.CD_CTR_CRED 
	
	INNER JOIN dbo.RC_CREDIARIO_PARC ON  
	dbo.RC_CREDIARIO_PARC_CRED.CD_EMP = dbo.RC_CREDIARIO_PARC.CD_EMP AND
	dbo.RC_CREDIARIO_PARC_CRED.CD_CTR = dbo.RC_CREDIARIO_PARC.CD_CTR 
	
	INNER JOIN RC_CLI_CREDIARIO ON  
	RC_CLI_CREDIARIO.CD_EMP=RC_CREDIARIO_PARC.CD_EMP AND
	RC_CLI_CREDIARIO.CD_CLI=RC_CREDIARIO_PARC.CD_CLI 
	
	INNER JOIN  RC_MDL_VENDA ON 
	RC_MDL_VENDA.CD_EMP=RC_CLI_CREDIARIO.CD_EMP AND
	RC_MDL_VENDA.CD_MDL_VD=RC_CLI_CREDIARIO.CD_MDL_VD
WHERE	 
	RC_PGTO_PDV_PENDENTE.CD_EMP=1